select   daten.Bezeichnung,
         daten.Kuerzel,
         daten.Vorgangskennzeichen,

         sum(daten.Jahr1) as "Jahressumme vor 5 Jahren",
         sum(daten.Jahr2) as "Jahressumme vor 4 Jahren",
         sum(daten.Jahr3) as "Jahressumme vor 3 Jahren",
         sum(daten.Jahr4) as "Jahressumme vor 2 Jahren",
         sum(daten.Jahr5) as "Jahressumme vor 1 Jahr"
         
from     ( 

         select   'Basiszahl 40.4.6' as "Bezeichnung",
                  isnull(k.kennzeichen,'(ohne)') as "Kuerzel",
                  isnull(k.bezeichnung,'(ohne)') as "Vorgangskennzeichen",

                  count(distinct(case when year(m.bisdatum) = year(getdate())-5 and s.berichtsjahr = year(getdate())-5
                                      and  floor(datediff(day,m.vondatum,m.bisdatum) / 30.42) > 36
                                      then h.massnahme else null end)) as "Jahr1",
                             
                  count(distinct(case when year(m.bisdatum) = year(getdate())-4 and s.berichtsjahr = year(getdate())-4
                                      and  floor(datediff(day,m.vondatum,m.bisdatum) / 30.42) > 36
                                      then h.massnahme else null end)) as "Jahr2",
                             
                  count(distinct(case when year(m.bisdatum) = year(getdate())-3 and s.berichtsjahr = year(getdate())-3
                                      and  floor(datediff(day,m.vondatum,m.bisdatum) / 30.42) > 36
                                      then h.massnahme else null end)) as "Jahr3",   
                             
                  count(distinct(case when year(m.bisdatum) = year(getdate())-2 and s.berichtsjahr = year(getdate())-2
                                      and  floor(datediff(day,m.vondatum,m.bisdatum) / 30.42) > 36
                                      then h.massnahme else null end)) as "Jahr4",
                             
                  count(distinct(case when year(m.bisdatum) = year(getdate())-1 and s.berichtsjahr = year(getdate())-1
                                      and  floor(datediff(day,m.vondatum,m.bisdatum) / 30.42) > 36
                                      then h.massnahme else null end)) as "Jahr5"                                                                                                                                               

         from     n_vorgang v inner join n_vorgmassnahme h on v.vorgangsnummer = h.vorgang
                              inner join n_hzestatistik s on h.massnahme = s.massnahmennummer
                              inner join n_massnahme m on h.massnahme = m.massnahmennummer
                              left join n_kennz k on v.kennz_fk = k.lfdnr

          where   (s.artderhilfe in ('04','05','06','07')
                  or (s.artderhilfe in ('12','14','15','16') and s.ortdurchfuehrung in ('01','06','10','13','14')) )
          and     s.freigegeben = '1'
          and     s.folgendehilfe = '6'

          group by  isnull(k.kennzeichen,'(ohne)'),
                    isnull(k.bezeichnung,'(ohne)')

         ) as daten
         
group by daten.Bezeichnung,
         daten.Kuerzel,
         daten.Vorgangskennzeichen

order by daten.Bezeichnung,
         daten.Kuerzel,
         daten.Vorgangskennzeichen